var vB_CategoryTitle_Editor = null;

function vB_AJAX_Categorylist_Init(categorylistid)
{
	if (AJAX_Compatible && (typeof vb_disable_ajax == 'undefined' || vb_disable_ajax < 2))
	{
		var tds = fetch_tags(fetch_object(categorylistid), 'td');
		for (var i = 0; i < tds.length; i++)
		{
			if (tds[i].hasChildNodes() && tds[i].id && tds[i].id.substr(0, 3) == 'td_')
			{
				var anchors = fetch_tags(tds[i], 'a');
				for (var j = 0; j < anchors.length; j++)
				{
					if (anchors[j].rel && anchors[j].rel.indexOf('vB::AJAX') != -1)
					{
						var details = tds[i].id.split('_');

						switch (details[1])
						{
							case 'categorytitle':
							{
								if (typeof vb_disable_ajax == 'undefined' || vb_disable_ajax == 0)
								{
									tds[i].style.cursor = 'default';
									tds[i].ondblclick = vB_AJAX_CategoryList_Events.prototype.categorytitle_doubleclick;
								}
							}
							break;
						}

						break;
					}
				}
			}
		}
	}
}

function vB_AJAX_CategorytitleEdit(obj)
{
	this.obj = obj;
	this.categoryid = this.obj.id.substr(this.obj.id.lastIndexOf('_') + 1);
	this.linkobj = fetch_object('category_title_' + this.categoryid);
	this.container = this.linkobj.parentNode;
	this.editobj = null;
	this.xml_sender = null;

	this.origtitle = '';
	this.editstate = false;

	this.edit = function()
	{
		if (this.editstate == false)
		{
			// create the new editor input box properties...
			this.inputobj = document.createElement('input');
			this.inputobj.type = 'text';
			this.inputobj.size = 50;
			// read in value for titlemaxchars from $vbulletin->options['titlemaxchars'], specified in template or default to 85
			this.inputobj.maxLength = ((typeof(titlemaxchars) == "number" && titlemaxchars > 0) ? titlemaxchars : 85);
			this.inputobj.style.width = Math.max(this.linkobj.offsetWidth, 250) + 'px';
			this.inputobj.className = 'bginput';
			this.inputobj.value = PHP.unhtmlspecialchars(this.linkobj.innerHTML);
			this.inputobj.title = this.inputobj.value;

			// ... and event handlers
			this.inputobj.onblur = vB_AJAX_CategoryList_Events.prototype.titleinput_onblur;
			this.inputobj.onkeypress = vB_AJAX_CategoryList_Events.prototype.titleinput_onkeypress;

			// insert the editor box and select it
			this.editobj = this.container.insertBefore(this.inputobj, this.linkobj);
			this.editobj.select();

			// store the original text
			this.origtitle = this.linkobj.innerHTML;

			// hide the link object
			this.linkobj.style.display = 'none';

			// declare that we are in an editing state
			this.editstate = true;
		}
	}

	this.restore = function()
	{
		if (this.editstate == true)
		{
			// do we actually need to save?
			if (this.editobj.value != this.origtitle)
			{
				this.linkobj.innerHTML = PHP.htmlspecialchars(this.editobj.value);
				this.save(this.editobj.value);
			}
			else
			{
				// set the new contents for the link
				this.linkobj.innerHTML = this.editobj.value;
			}

			// remove the editor box
			this.container.removeChild(this.editobj);

			// un-hide the link
			this.linkobj.style.display = '';

			// declare that we are in a normal state
			this.editstate = false;
			this.obj = null;
		}
	}

	this.save = function(titletext)
	{
		YAHOO.util.Connect.asyncRequest("POST", "umg_ajax.php?do=updatecategorytitle&categoryid=" + this.categoryid, {
			success: this.handle_ajax_response,
			timeout: vB_Default_Timeout,
			scope: this
		}, SESSIONURL + "securitytoken=" + SECURITYTOKEN + "&do=updatecategorytitle&categoryid=" + this.categoryid + '&title=' + PHP.urlencode(titletext));
	}

	this.handle_ajax_response = function(ajax)
	{
		if (ajax.responseXML)
		{
			this.linkobj.innerHTML = ajax.responseXML.getElementsByTagName('linkhtml')[0].firstChild.nodeValue;
		}

		vB_CategoryTitle_Editor.obj = null;
	}

	// start the editor
	this.edit();
}

function vB_AJAX_CategoryList_Events()
{
}

vB_AJAX_CategoryList_Events.prototype.categorytitle_doubleclick = function(e)
{
	if (vB_CategoryTitle_Editor && vB_CategoryTitle_Editor.obj == this)
	{
		return false;
	}
	else
	{
		try
		{
			vB_CategoryTitle_Editor.restore();
		}
		catch(e) {}

		vB_CategoryTitle_Editor = new vB_AJAX_CategorytitleEdit(this);
	}
};

vB_AJAX_CategoryList_Events.prototype.titleinput_onblur = function(e)
{
	vB_CategoryTitle_Editor.restore();
};

vB_AJAX_CategoryList_Events.prototype.titleinput_onkeypress = function (e)
{
	e = e ? e : window.event;
	switch (e.keyCode)
	{
		case 13: // return / enter
		{
			vB_CategoryTitle_Editor.inputobj.blur();
			return false;
		}
		case 27: // escape
		{
			vB_CategoryTitle_Editor.inputobj.value = vB_CategoryTitle_Editor.origtitle;
			vB_CategoryTitle_Editor.inputobj.blur();
			return true;
		}
	}
};
